# 画面設計書 151-Cat ヘルス

## 概要

本ドキュメントは、OpenSearchのCat Health API（`GET /_cat/health`）エンドポイントに関する画面設計書である。クラスタのヘルス情報を人間が読みやすいテーブル形式で返すAPIの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：クラスタの健全性を迅速に確認するために使用される。運用監視において、クラスタのステータス（green/yellow/red）、ノード数、シャードの状態、保留中タスク数などを一目で把握できるため、障害の早期発見やクラスタ状態の日常監視に不可欠なAPIである。Cat APIシリーズの一つとして、他のCat APIと同様にテーブル形式で出力される。

**画面へのアクセス方法**：HTTPクライアント（curl、OpenSearch Dashboardsなど）から `GET /_cat/health` にリクエストを送信してアクセスする。`?v` パラメータを付与するとカラムヘッダーが表示される。

**主要な操作・処理内容**：
1. クラスタヘルスリクエスト（ClusterHealthRequest）を発行し、クラスタの健全性情報を取得する
2. 取得したClusterHealthResponseからテーブル形式のレスポンスを構築する
3. クラスタ名、ステータス、ノード数、シャード情報、保留中タスク数、アクティブシャード割合などを表示する

**画面遷移**：本APIはステートレスなREST APIであり、画面遷移の概念は存在しない。クラスタヘルスAPI（`GET /_cluster/health`）と同等の情報をテーブル形式で返す簡易版として位置づけられる。

**権限による表示制御**：セキュリティプラグインが有効な場合、クラスタモニタリング権限（`cluster:monitor/health`）が必要となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | クラスタヘルス | 主機能 | クラスタヘルスの簡潔なテーブル形式表示を返す処理 |

## 画面種別

一覧（テーブル形式のヘルス情報表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/health` | クラスタヘルス情報をテーブル形式で返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| format | string | No | - | レスポンス形式（json, yamlなど） |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| time | enum | No | - | 時間値の表示単位（d/h/m/s/ms/micros/nanos） |
| ts | boolean | No | true | タイムスタンプを無効化するにはfalseを設定 |
| v | boolean | No | false | 冗長モード。カラムヘッダーを表示 |

## 表示項目

| カラム名 | エイリアス | 説明 | テキスト配置 |
|---------|-----------|------|-------------|
| timestamp | ts,hms,hhmmss | タイムスタンプ | - |
| cluster | cl | クラスタ名 | - |
| status | st | ヘルスステータス（green/yellow/red） | - |
| node.total | nt,nodeTotal | ノード総数 | 右寄せ |
| node.data | nd,nodeData | データノード数 | 右寄せ |
| discovered_cluster_manager | dcm,dm | クラスタマネージャ検出状態 | 右寄せ |
| shards | t,sh,shardsTotal | シャード総数 | 右寄せ |
| pri | p,shardsPrimary | プライマリシャード数 | 右寄せ |
| relo | r,shardsRelocating | 再配置中シャード数 | 右寄せ |
| init | i,shardsInitializing | 初期化中シャード数 | 右寄せ |
| unassign | u,shardsUnassigned | 未割り当てシャード数 | 右寄せ |
| pending_tasks | pt,pendingTasks | 保留中タスク数 | 右寄せ |
| max_task_wait_time | mtwt,maxTaskWaitTime | 最長タスク待機時間 | 右寄せ |
| active_shards_percent | asp,activeShardsPercent | アクティブシャード割合（%） | 右寄せ |

## イベント仕様

### 1-GETリクエスト受信

クライアントからのGETリクエストを受信すると、`RestHealthAction.doCatRequest()` が呼び出される。ClusterHealthRequestを生成し、クラスタのヘルス情報を非同期で取得する。レスポンスを受信後、`buildTable()` メソッドでテーブルを構築し、`RestTable.buildResponse()` でレスポンスを返却する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | 参照のみ。データベースへの更新は発生しない |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|-------------|
| 正常応答 | ヘルス取得成功時 | テーブル形式のヘルス情報 |
| エラー | クラスタ未起動時 | 接続エラー |

## 例外処理

- クラスタが応答しない場合：接続タイムアウトエラーが返される
- 権限不足の場合：403 Forbiddenが返される

## 備考

- `?ts=false` を指定するとタイムスタンプカラムを非表示にできる
- `?v` パラメータでカラムヘッダーを表示できる
- レスポンスは常に1行（現在のクラスタヘルス状態）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

クラスタヘルス情報のレスポンスデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClusterHealthResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/health/ClusterHealthResponse.java` | クラスタヘルス情報を保持するレスポンスクラス。getStatus(), getNumberOfNodes(), getActiveShards() 等のメソッドを確認 |

**読解のコツ**: ClusterHealthResponseはClusterHealthStatusを持ち、GREEN/YELLOW/REDの3値を返す。

#### Step 2: エントリーポイントを理解する

REST APIのハンドラクラスがリクエストを受け付ける流れを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestHealthAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestHealthAction.java` | Cat Health APIのエントリーポイント。routes()でGET /_cat/healthを登録 |

**主要処理フロー**:
1. **行57-59**: `routes()` メソッドで `GET /_cat/health` をルート登録
2. **行77-86**: `doCatRequest()` でClusterHealthRequestを生成し、非同期でヘルス情報を取得
3. **行89-113**: `getTableWithHeader()` でテーブルヘッダー定義（14カラム）
4. **行115-133**: `buildTable()` でClusterHealthResponseからテーブル行を構築

#### Step 3: テーブル出力処理を理解する

Cat APIの共通テーブルレンダリング処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | Cat API共通基底クラス。helpパラメータ処理やレスポンスパラメータ管理 |
| 3-2 | RestTable.java | `server/src/main/java/org/opensearch/rest/action/cat/RestTable.java` | テーブルをtext/json/yaml形式でレンダリングする処理 |

### プログラム呼び出し階層図

```
RestHealthAction.doCatRequest() [行77]
    |
    +-- ClusterHealthRequest() [行78]
    |
    +-- client.admin().cluster().health() [行80]
           |
           +-- RestResponseListener.buildResponse() [行82-84]
                  |
                  +-- buildTable() [行115]
                  |      +-- getTableWithHeader() [行89]
                  |      +-- Table.startRow() / addCell() / endRow()
                  |
                  +-- RestTable.buildResponse() [行83]
```

### データフロー図

```
[入力]               [処理]                    [出力]

GET /_cat/health --> RestHealthAction          --> テーブル形式テキスト
                     .doCatRequest()
                         |
                         v
                    ClusterHealthRequest
                         |
                         v
                    ClusterHealthResponse
                         |
                         v
                    buildTable()
                         |
                         v
                    RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestHealthAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestHealthAction.java` | ソース | Cat Health APIのRESTハンドラ |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API共通基底クラス |
| RestTable.java | `server/src/main/java/org/opensearch/rest/action/cat/RestTable.java` | ソース | テーブルレンダリング処理 |
| ClusterHealthRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/health/ClusterHealthRequest.java` | ソース | クラスタヘルスリクエスト |
| ClusterHealthResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/health/ClusterHealthResponse.java` | ソース | クラスタヘルスレスポンス |
| cat.health.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.health.json` | 設定 | REST API仕様定義 |
